<?php

defined( 'ABSPATH' ) || exit;
$categories       = get_categories();
$category_choices = array();

foreach ( $categories as $category ) {
	$category_choices[ $category->term_id ] = $category->name;
}

$options = array(
	'colormag_news_ticker_title' => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'News Ticker', 'colormag' ),
		'section'      => 'colormag_header_builder_news_ticker',
		'sub_controls' => apply_filters(
			'colormag_news_ticker_sub_controls',
			array(
				'colormag_enable_news_ticker'              => array(
					'title'     => esc_html__( 'Enable', 'colormag' ),
					'default'   => false,
					'type'      => 'customind-toggle',
					'section'   => 'colormag_header_builder_news_ticker',
					'condition' => array(
						'colormag_news_ticker_position' => 'below-header',
					),
				),
				'colormag_news_ticker_width'               => array(
					'default'     => array(
						'size'  => 240,
						'units' => 'px',
					),
					'type'        => 'customind-slider',
					'title'       => esc_html__( 'Width', 'colormag' ),
					'section'     => 'colormag_header_builder_button_1',
					'units'       => array( 'px' ),
					'defaultUnit' => 'px',
				),
				'colormag_news_ticker_position'            => array(
					'default' => 'top-bar',
					'type'    => 'customind-select',
					'title'   => esc_html__( 'Position', 'colormag' ),
					'section' => 'colormag_header_builder_news_ticker',
					'choices' => array(
						'top-bar'      => esc_html__( 'Header', 'colormag' ),
						'below-header' => esc_html__( 'Below Header', 'colormag' ),
					),
				),
				'colormag_news_ticker_query'               => array(
					'default' => 'latest',
					'type'    => 'customind-select',
					'title'   => esc_html__( 'Filter', 'colormag' ),
					'section' => 'colormag_header_builder_news_ticker',
					'choices' => array(
						'latest'   => esc_html__( 'Latest Posts', 'colormag' ),
						'category' => esc_html__( 'Category', 'colormag' ),
					),
				),
				'colormag_news_ticker_category'            => array(
					'type'      => 'customind-select',
					'title'     => esc_html__( 'Category', 'colormag' ),
					'section'   => 'colormag_header_builder_news_ticker',
					'choices'   => $category_choices,
					'condition' => array(
						'colormag_news_ticker_query' => 'category',
					),
				),
				'colormag_news_ticker_animation_direction' => array(
					'default' => 'down',
					'type'    => 'customind-select',
					'title'   => esc_html__( 'Animation Style', 'colormag' ),
					'section' => 'colormag_header_builder_news_ticker',
					'choices' => array(
						'up'     => esc_html__( 'Up', 'colormag' ),
						'down'   => esc_html__( 'Down', 'colormag' ),
						'left'   => esc_html__( 'Left', 'colormag' ),
						'right'  => esc_html__( 'Right', 'colormag' ),
						'fade'   => esc_html__( 'Fade', 'colormag' ),
						'scroll' => esc_html__( 'Marquee', 'colormag' ),
					),
				),
				'colormag_news_ticker_animation_duration'  => array(
					'title'       => esc_html__( 'Auto Play Intervel', 'colormag' ),
					'default'     => 5000,
					'type'        => 'customind-text',
					'section'     => 'colormag_header_builder_news_ticker',
					'input_attrs' => array(
						'type' => 'number',
					),
				),
				'colormag_news_ticker_animation_speed'     => array(
					'title'       => esc_html__( 'Transition Speed', 'colormag' ),
					'default'     => 1,
					'type'        => 'customind-text',
					'section'     => 'colormag_header_builder_news_ticker',
					'input_attrs' => array(
						'type' => 'number',
					),
				),
				'colormag_news_ticker_label'               => array(
					'title'     => esc_html__( 'Label', 'colormag' ),
					'default'   => 'Latest:',
					'type'      => 'customind-text',
					'section'   => 'colormag_header_builder_news_ticker',
					'transport' => 'postMessage',
				),
				'colormag_news_ticker_color'               => array(
					'title'     => esc_html__( 'Color', 'colormag' ),
					'default'   => '',
					'type'      => 'customind-color',
					'section'   => 'colormag_header_builder_news_ticker',
					'transport' => 'postMessage',
				),
				'colormag_news_ticker_link_color'          => array(
					'title'     => esc_html__( 'Link Color', 'colormag' ),
					'default'   => '',
					'type'      => 'customind-color',
					'section'   => 'colormag_header_builder_news_ticker',
					'transport' => 'postMessage',
				),
				'colormag_news_ticker_typography'          => array(
					'default'   => array(
						'font-family'    => 'inherit',
						'font-weight'    => 'regular',
						'subsets'        => array( 'latin' ),
						'font-size'      => array(
							'desktop' => array(
								'size' => '',
								'unit' => 'px',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => 'px',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => 'px',
							),
						),
						'line-height'    => array(
							'desktop' => array(
								'size' => '',
								'unit' => '-',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '-',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '-',
							),
						),
						'font-style'     => 'normal',
						'text-transform' => 'none',
					),
					'type'      => 'customind-typography',
					'transport' => 'postMessage',
					'title'     => esc_html__( 'Latest Typography', 'colormag' ),
					'section'   => 'colormag_header_builder_news_ticker',
				),
				'colormag_news_ticker_content_typography'  => array(
					'default' => array(
						'font-family'    => 'inherit',
						'font-weight'    => 'regular',
						'font-size'      => array(
							'desktop' => array(
								'size' => '',
								'unit' => 'px',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => 'px',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => 'px',
							),
						),
						'line-height'    => array(
							'desktop' => array(
								'size' => '',
								'unit' => '-',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '-',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '-',
							),
						),
						'font-style'     => 'normal',
						'text-transform' => 'none',
					),
					'type'    => 'customind-typography',
					'title'   => esc_html__( 'Content Typography', 'colormag' ),
					'section' => 'colormag_header_builder_news_ticker',
				),
			)
		),
		'collapsible'  => apply_filters( 'colormag_news_ticker_accordion_collapsible', false ),
	),
);

colormag_customind()->add_controls( $options );
